<?php

if (!defined('ABSPATH')) die;

class KST_Related_Block extends KST_Editor_Block {

    protected $ID = 'related';

    protected $attrs_map = array(
        'title' => 'title',
        'mode' => 'mode',
        'ids' => 'ids',
        'limit' => 'limit',
    );

    public function render($attrs) {
        // TODO: in shortcode and Elementor as well
        $title = isset($attrs["title"]) && $attrs["title"] ? $attrs["title"] : MKB_Options::option('related_content_label');
        $mode = isset($attrs['mode']) ? $attrs['mode'] : 'manual';
        $limit = isset($attrs['limit']) ? $attrs['limit'] : 5;
        $ids = explode(",", $attrs["ids"]);

        if ($mode === 'topic') {
            $ids = array();

            if (!is_singular(MKB_Options::option('article_cpt'))) {
                echo __('<p>Warning! Current topic mode works only for KB articles</p>', 'minerva-kb');

                return;
            }

            $term = MKB_TemplateHelper::get_article_main_topic(get_the_ID());

            if (!$term) {
                return;
            }

            $query_args = array(
                'post_type' => MKB_Options::option( 'article_cpt' ),
                'ignore_sticky_posts' => 1,
                'posts_per_page' => $limit,
                'post__not_in' => array(get_the_ID()),
                'tax_query' => array(
                    array(
                        'taxonomy' => MKB_Options::option('article_cpt_category'),
                        'field' => 'slug',
                        'terms' => $term->slug,
                    ),
                )
            );

            $topic_loop = new WP_Query( $query_args );

            if ($topic_loop->have_posts()):
                while ( $topic_loop->have_posts() ) : $topic_loop->the_post();
                    array_push($ids, get_the_ID());
                endwhile;
            endif;

            wp_reset_postdata();
        }

        if ($ids && is_array($ids) && !empty($ids)):
            ?>
            <div class="mkb-related-content">
                <div class="mkb-related-content-title"><?php echo esc_html($title); ?></div>
                <ul class="mkb-related-content-list">
                    <?php foreach($ids as $id):
                        if ( empty($id) || !is_string( get_post_status( $id )) ) {
                            continue;
                        }
                        ?>
                        <li><a href="<?php echo esc_url(get_permalink($id)); ?>"><?php echo esc_html(get_the_title($id)); ?></a></li>
                    <?php endforeach; ?>
                </ul>
            </div>
        <?php
        endif;
    }

    public function custom_options() {
        return array(
            'title' => array(
                'id' => 'title',
                'type' => 'input',
                'label' => __( 'Title (optional)', 'minerva-kb' ),
                'default' => '',
                'description' => __( 'By default, the title from global settings is used', 'minerva-kb' ),
            ),
            'mode' => array(
                'id' => 'mode',
                'type' => 'select',
                'label' => __( 'Related articles mode', 'minerva-kb' ),
                'options' => array(
                    'manual' => __( 'Manual', 'minerva-kb' ),
                    'topic' => __( 'Current topic', 'minerva-kb' ),
                ),
                'default' => 'manual',
                'description' => __( 'Choose articles manually or display articles from current topic', 'minerva-kb' )
            ),
            'ids' => array(
                'id' => 'ids',
                'type' => 'articles_list',
                'label' => __( 'Select related articles', 'minerva-kb' ),
                'default' => ''
            ),
            'limit' => array(
                'id' => 'limit',
                'type' => 'input',
                'label' => __( 'Limit articles from current topic', 'minerva-kb' ),
                'default' => 5,
                'description' => __( 'For Current topic mode. Use -1 to show all.', 'minerva-kb' ),
            ),
        );
    }
}

